@component('mail::message')
# {{ __('scs::messages.email_template.order_shipped_subject') }}

{{ __('scs::messages.email_template.order_shipped_text') }}

**{{ __('scs::messages.email_template.order_number') }}:** #{{ $order->orderNumber() }}

@component('mail::table')
| {{ __('scs::messages.items') }}       | {{ __('scs::messages.quantity') }}         | {{ __('scs::messages.total') }} |
| :--------- | :------------- | :----- |
@foreach ($order->lineItems() as $lineItem)
| [{{ $lineItem->product()->get('title') }}]({{ optional($lineItem->product()->resource())->absoluteUrl() }}) | {{ $lineItem->quantity() }} | {{ \DoubleThreeDigital\SimpleCommerce\Currency::parse($lineItem->total(), $site) }} |
@endforeach
| | {{ __('scs::messages.subtotal') }}: | {{ \DoubleThreeDigital\SimpleCommerce\Currency::parse($order->itemsTotal(), $site) }}
@if($order->coupon())
| | {{ __('scs::messages.coupon') }}: | -{{ \DoubleThreeDigital\SimpleCommerce\Currency::parse($order->couponTotal(), $site) }}
@endif
| | {{ __('scs::messages.delivery') }}: | {{ \DoubleThreeDigital\SimpleCommerce\Currency::parse($order->shippingTotal(), $site) }}
| | {{ __('scs::messages.taxes') }}: | {{ \DoubleThreeDigital\SimpleCommerce\Currency::parse($order->taxTotal(), $site) }}
| | **{{ __('scs::messages.total') }}:** | {{ \DoubleThreeDigital\SimpleCommerce\Currency::parse($order->grandTotal(), $site) }}
| | |
@endcomponent

## {{ __('scs::messages.email_template.customer_details') }}

@if($order->customer())
* **{{ __('scs::messages.name') }}:** {{ $order->customer()->name() }}
* **{{ __('scs::messages.email') }}:** {{ $order->customer()->email() }}
@endif

@if($order->billingAddress())
* **{{ __('scs::messages.checkout.billing_address') }}:** {{ $order->billingAddress()->__toString() }}
@endif

@if($order->shippingAddress())
* **{{ __('scs::messages.checkout.delivery_address') }}:** {{ $order->shippingAddress()->__toString() }}
@endif

<br>

{{ __('scs::messages.email_template.question_text') }}

{{ __('scs::messages.email_template.closure') }}<br>
{{ config('app.name') }}
@endcomponent
