@extends('email-layout')

@section('preheader', __('scs::messages.email_template.magic_link'))

@section('content')
<p>{{ __('scs::messages.email_template.hello') }},</p>
<p>{{ __('scs::messages.email_template.magic_link') }}</p>

<p>{{ __('scs::messages.email_template.magic_link_expiration') }}</p>

<!-- Magic Link -->
<table class="attributes" align="center" width="100%" cellpadding="0" cellspacing="0" role="presentation">
  <tr>
    <td class="attributes_content" align="center">
      <table width="100%" cellpadding="0" cellspacing="0" role="presentation">
        <tr>
          <td class="attributes_item" align="center">
            <span class="f-fallback">
              <strong><a href="{{ $url }}">{{ __('scs::messages.auth.login.title') }}</a></strong>
            </span>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<!-- End Magic Link -->

<p>{{ __('scs::messages.email_template.magic_link_otp') }}</p>

<!-- Code -->
<table class="attributes" align="center" width="100%" cellpadding="0" cellspacing="0" role="presentation">
  <tr>
    <td class="attributes_content" align="center">
      <table width="100%" cellpadding="0" cellspacing="0" role="presentation">
        <tr>
          <td class="attributes_item" align="center">
            <span class="f-fallback">
              <strong>{{ $otp }}</strong>
            </span>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<!-- End Code -->

<p>{{ __('scs::messages.email_template.safely_ignore') }}</p>
<p>{{ __('scs::messages.email_template.closure') }}</p>

<!-- Sub copy -->
<table class="body-sub" role="presentation">
  <tr>
    <td>
      <p class="f-fallback sub">{{ __('scs::messages.email_template.url_trouble') }} {{ $url }}</p>
    </td>
  </tr>
</table>
@endsection
