<?php

use MichaelRavedoni\SimpleCommerceSwitzerland\Http\Controllers\CustomerAuthController;
use MichaelRavedoni\SimpleCommerceSwitzerland\Http\Controllers\InvoiceController;
use MichaelRavedoni\SimpleCommerceSwitzerland\Http\Controllers\PaymentController;

Route::statamic('/cart', 'cart', ['title' => 'Your Cart']);

Route::redirect('/checkout', '/checkout/information');
Route::statamic('/checkout/information', 'checkout.information', ['title' => 'Checkout - Information']);
Route::statamic('/checkout/shipping', 'checkout.shipping', ['title' => 'Checkout - Shipping']);
Route::statamic('/checkout/payment', 'checkout.payment', ['title' => 'Checkout - Payment']);
Route::statamic('/checkout/complete', 'checkout.complete', ['title' => 'Checkout - Complete']);

Route::statamic('/auth/register', 'auth.register', ['title' => 'Register']);
Route::statamic('/auth/logout', 'auth.logout', ['title' => 'logout']);


Route::get('/auth/login', [CustomerAuthController::class, 'login'])->name('auth.login');
Route::get('/auth/logout', [CustomerAuthController::class, 'logout'])->name('auth.logout');
Route::get('/auth/register', [CustomerAuthController::class, 'register'])->name('auth.register');
Route::post('/auth/store', [CustomerAuthController::class, 'store'])->name('auth.register.store');
Route::get('/account', [CustomerAuthController::class, 'account'])->name('account')->middleware([\MichaelRavedoni\SimpleCommerceSwitzerland\Http\Middleware\CustomerAuth::class]);
Route::post('/account/update', [CustomerAuthController::class, 'accountUpdate'])->name('account.update');

Route::post('/auth/login/check', [CustomerAuthController::class, 'loginCheck'])->name('auth.login.check');
Route::post('/auth/magic-link/send', [CustomerAuthController::class, 'sendMagicLink'])->name('auth.send_magic_link');
Route::get('/auth/magic-link/check', [CustomerAuthController::class, 'checkMagicLink'])->name('auth.check_magic_link');
Route::get('/auth/magic-link/enter', [CustomerAuthController::class, 'enterMagicLink'])->name('auth.enter_magic_link');

Route::get('/account/orders/{order}', [CustomerAuthController::class, 'order'])->name('auth.order');

Route::get('/invoices/{orderId}', [InvoiceController::class, 'showInvoice'])->name('invoice.show');
Route::get('/receipts/{orderId}', [InvoiceController::class, 'showReceipt'])->name('receipt.show');

Route::get('order/{orderId}/payment/success', [PaymentController::class, 'success'])->name('order.payment.success');
