<?php

namespace MichaelRavedoni\SimpleCommerceSwitzerland\Gateways;

use DoubleThreeDigital\SimpleCommerce\Contracts\Gateway;
use DoubleThreeDigital\SimpleCommerce\Contracts\Order;
use DoubleThreeDigital\SimpleCommerce\Gateways\BaseGateway;
use DoubleThreeDigital\SimpleCommerce\Gateways\Prepare;
use DoubleThreeDigital\SimpleCommerce\Gateways\Purchase;
use DoubleThreeDigital\SimpleCommerce\Gateways\Response;
use DoubleThreeDigital\SimpleCommerce\Currency;
use DoubleThreeDigital\SimpleCommerce\Exceptions\GatewayDoesNotSupportPurchase;
use DoubleThreeDigital\SimpleCommerce\Facades\Order as OrderFacade;
use Statamic\Facades\Site;
use Statamic\Facades\Entry;
use Illuminate\Http\Request;

class Loxopay extends BaseGateway implements Gateway
{
    public function name(): string
    {
        return 'Loxopay';
    }

    public function prepare(Prepare $data): Response
    {

        $order = $data->order();
        $locale = $data->request()->locale ?? $data->request()->defaultLocale;
        $amount = data_get($order, 'grandTotal');
        $currency = Currency::get(Site::current())['code'];
        $redirect_url = 'https://'.$this->config()->get('instance').'.loxopay.ch/'.$locale.'/vpos?amount='.$amount.'&currency='.$currency;

        $loxopay = new \Loxopay\Loxopay($this->config()->get('instance'), $this->config()->get('api_secret'));
        $gateway = new \Loxopay\Models\Request\Gateway();
        $gateway->setAmount($amount);
        $gateway->setVatRate(0);
        $gateway->setSku(null);
        $gateway->setCurrency($currency);
        $gateway->setReferenceId($order->id);
        $gateway->setSuccessRedirectUrl(route('order.payment.success', ['orderId' => $order->id]));
        $gateway->setFailedRedirectUrl(url('/checkout/payment'));
        $gateway->setCancelRedirectUrl(url()->current());
        $gateway->addField('order_number', $order->get('title'));
        $gateway->addField('company', $order->get('shipping_name'));
        $gateway->addField('email', data_get($order, 'customer.email'));
        try {
            $response = $loxopay->create($gateway);

        } catch (\Loxopay\LoxopayException $e) {
            print $e->getMessage();
        }

        // add data to order
        $orderEntry = Entry::find($order->id);
        $orderEntry->set('gateway', [
            'use' => 'MichaelRavedoni\SimpleCommerceSwitzerland\Gateways\Loxopay',
            'data' => []
        ]);
        $orderEntry->save();

        return new Response(true, [
            'redirect_url' => $response->getLink(),
            'gateway_id' => $response->getId(),
        ]);
    }

    public function purchase(Purchase $data): Response
    {

        return new Response();
    }

    public function purchaseRules(): array
    {
        return [];
    }

    public function purchaseMessages(): array
    {
        return [];
    }

    public function getCharge(Order $order): Response
    {

        return new Response(true, []);
    }

    public function refundCharge(Order $order): Response
    {
        return new Response(true, []);
    }

    public function webhook(Request $request)
    {
        $transaction = $request->input('transaction');
        $referenceId = data_get($transaction, 'referenceId');
        $transaction = [
            'id' => data_get($transaction, 'id'),
            'uuid' => data_get($transaction, 'uuid'),
            'status' => data_get($transaction, 'status'),
            'time' => data_get($transaction, 'time'),
            'mode' => data_get($transaction, 'mode'),
            //'data' => $transaction,
        ];

        if (empty($transaction) || empty($referenceId)) {
            return 'No reference id or transaction founded.';
        }

        $orderEntry = Entry::find($referenceId);

        if (empty($orderEntry)) {
            return 'No related order founded.';
        }

        $orderEntry->set('gateway', [
            'use' => 'MichaelRavedoni\SimpleCommerceSwitzerland\Gateways\Loxopay',
            'data' => $transaction,
        ]);
        $orderEntry->save();

        return 'OK';
    }

    public function paymentDisplay($value): array
    {
        return [
            'text' => isset($value['data']) ? $value['data']['uuid'] : '#',
            'url' => isset($value['data']) ? 'https://'.$this->config()->get('instance').'.loxopay.ch/cadmin/index.php?cmd=checkout&act=payments&id='.$value['data']['uuid'] : '#',
        ];
    }
}
