<?php

namespace MichaelRavedoni\SimpleCommerceSwitzerland\Gateways;

use DoubleThreeDigital\SimpleCommerce\Contracts\Gateway;
use DoubleThreeDigital\SimpleCommerce\Contracts\Order;
use DoubleThreeDigital\SimpleCommerce\Gateways\BaseGateway;
use DoubleThreeDigital\SimpleCommerce\Gateways\Prepare;
use DoubleThreeDigital\SimpleCommerce\Gateways\Purchase;
use DoubleThreeDigital\SimpleCommerce\Gateways\Response;
use Illuminate\Http\Request;
use Statamic\Facades\Entry;

class PostPay extends BaseGateway implements Gateway
{
    public function name(): string
    {
        return 'Postpay';
    }

    public function prepare(Prepare $data): Response
    {
        return new Response(true, []);
    }

    public function purchase(Purchase $data): Response
    {
        $order = $data->order();
        $this->markOrderAsPaid($order);

        return new Response(true, [
            'id' => 'R'.$order->get('order_number'),
            'url' => route('invoice.show', ['orderId' => $order->id]),
            'status' => 'pending',
        ]);
    }

    public function purchaseRules(): array
    {
        return [];
    }

    public function getCharge(Order $order): Response
    {
        return new Response(true, []);
    }

    public function refundCharge(Order $order): Response
    {
        return new Response(true, []);
    }

    public function webhook(Request $request)
    {
        return null;
    }

    /**
     * Should return an array with text & a URL which will be displayed by the Gateway fieldtype in the CP.
     *
     * @return array
     */
    public function paymentDisplay($value): array
    {
        return [
            'text' => isset($value['data']) ? $value['data']['id'] : $value['id'],
            'url' => isset($value['data']) ? $value['data']['url'] : '#',
        ];
    }
}
