<?php

namespace MichaelRavedoni\SimpleCommerceSwitzerland\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CustomerAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $customerId = $request->session()->get('customer_id');

        if (empty($customerId)) {
            return redirect(route('auth.login'));
        }

        return $next($request);
    }
}
