<?php

namespace MichaelRavedoni\SimpleCommerceSwitzerland;

use Statamic\Providers\AddonServiceProvider;

class ServiceProvider extends AddonServiceProvider
{
    public function boot()
    {
        parent::boot();

        $this->loadTranslationsFrom(__DIR__.'/../resources/lang', 'simple-commerce-switzerland');
    }

    public function bootAddon()
    {
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'scs');
        $this->loadTranslationsFrom(__DIR__ . '/../resources/lang', 'scs');

        $this->publishes([
            __DIR__.'/../config/simple-commerce-switzerland.php' => config_path('simple-commerce-switzerland.php'),
        ], 'simple-commerce-switzerland-config');

        /*
        $this->publishes([
            __DIR__.'/../resources/views' => resource_path('views/vendor/simple-commerce-switzerland'),
        ]);

        $this->publishes([
            __DIR__.'/../resources/blueprints' => resource_path('blueprints'),
        ], 'simple-commerce-switzerland-blueprints');
        */
    }

    protected $routes = [
        'web' => __DIR__.'/../routes/web.php',
    ];

    protected $modifiers = [
        //
    ];
}
