<?php

namespace MichaelRavedoni\SimpleCommerceSwitzerland\ShippingMethods;

use DoubleThreeDigital\SimpleCommerce\Contracts\Order;
use DoubleThreeDigital\SimpleCommerce\Contracts\ShippingMethod;
use DoubleThreeDigital\SimpleCommerce\Orders\Address;
use DoubleThreeDigital\SimpleCommerce\Shipping\BaseShippingMethod;

class OnSite extends BaseShippingMethod implements ShippingMethod
{
    public function name(): string
    {
        return __('simple-commerce-switzerland::messages.shipping_methods.on_site.name');
    }

    public function description(): string
    {
        return __('simple-commerce-switzerland::messages.shipping_methods.on_site.indications');
    }

    public function calculateCost(Order $order): int
    {
        return 0;
    }

    public function checkAvailability(Order $order, Address $address): bool
    {
        return true;
    }
}
