<?php

namespace MichaelRavedoni\SimpleCommerceSwitzerland\ShippingMethods;

use DoubleThreeDigital\SimpleCommerce\Contracts\Order;
use DoubleThreeDigital\SimpleCommerce\Contracts\ShippingMethod;
use DoubleThreeDigital\SimpleCommerce\Orders\Address;
use DoubleThreeDigital\SimpleCommerce\Shipping\BaseShippingMethod;
use Illuminate\Support\Facades\Http;

class SwissPostInternationalEconomy extends BaseShippingMethod implements ShippingMethod
{
    public function name(): string
    {
        return __('simple-commerce-switzerland::messages.shipping_methods.swiss_post_international_economy.name');
    }

    public function description(): string
    {
        return __('simple-commerce-switzerland::messages.shipping_methods.swiss_post_international_economy.indications');
    }

    public function calculateCost(Order $order): int
    {
        $averageWeight = $this->config()->get('average_weight') ?? 2000;
        $country = $order->get('shipping_country');
        $product = $this->getPostApi($country, $averageWeight);

        return data_get($product, 'price') * 100;
    }

    public function checkAvailability(Order $order, Address $address): bool
    {
        $country = $order->get('shipping_country');
        return $country != 'CH';
    }

    public function getPostApi($countryCode, $weight = 2000)
    {
        $response = Http::withHeaders([
            'X-Apim-Api-Key' => env('POST_API_SECRET_KEY'),
        ])->get('https://vsc.apis.post.ch/product/v1/products?isoCode='.$countryCode.'&format=PK&weight='.$weight.'&lang=fr');
        $products = $response->json()['products'];
        $product = last($products);

        return $product;
    }
}
