# Statamic Site Kit

![Statamic 3.0+](https://img.shields.io/badge/Statamic-3.0+-FF269E?style=for-the-badge&link=https://statamic.com)

> Statamic Site Kit is a Statamic addon that makes your life easier.

## Features

This addon does:

- Add SEO configuration
- And website configuration
- And website data for template
- And git live change updates easier

## Install

Add this Composer repository to your project's root `composer.json` file:
``` json
{
  "repositories": [
    {
        "type": "composer",
        "url": "https://satis.ravedoni.li"
    }
  ]
}
```

Run the following command from your project root:
``` bash
composer require michaelravedoni/statamic-site-kit
```

Then publish the publishables from the service provider:
```
php artisan vendor:publish --provider="Michaelravedoni\StatamicSiteKit\ServiceProvider"
```

## Configuration
After installing, a config file will be created at `config/statamic-site-kit.php`. This will give you control over a number of config options:

| Setting | Type       | Description                                                 |
| --------- | ---------- | ----------------------------------------------------------- |
| `super_token`          | String  | The token query string for have a super admin access |
| `asset_container`      | String  | The asset container to store images in            |
| `asset_folder`         | String  | The folder inside the container to use            |
| `custom_socials`       | Array   | An array of custom socials to add to our selector |
| `excluded_collections` | Array   | An array of collections to exclude from adding the SEO tab |
| `excluded_taxonomies`  | Array   | An array of taxonomies to exclude from adding the SEO tab |

### Git integration
Ensure that your root project `.gitignore` is ok with what you want it to do.
Theses paths are normally where you have Statamic data :
```
/config
/content
/users
/resources/blueprints
/resources/fieldsets
/resources/forms
/resources/users
/resources/forms
/public/assets
```

### Change storage of collection definitions
Usually the collection `yaml` definitions are stored in `content/collections` next to the markdown files. But we can change this. We need to change `content/collections` to `resources/collections` in `config/stache.php`, these are the important lines:

```php
use Statamic\Stache\Stores;

'stores' => [

    'collections' => [
        'class' => Stores\CollectionsStore::class,
        'directory' => base_path('resources/collections'),
    ],

    'taxonomies' => [
        'class' => Stores\CollectionsStore::class,
        'directory' => base_path('resources/taxonomies'),
    ],
],
```

## Usage

### HTML boilerplate

```html
<!doctype html>
<html lang="{{ site:short_locale }}" dir="{{ site:dir ?? 'auto' }}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Style & librairies -->

        {{ ssk:head }}
        {{ stack:head }}

    </head>
    <body>
        {{ ssk:body }}
        {{ partial:header }}
        <main id="content">{{ template_content }}</main>
        {{ partial:footer }}

        
        <!-- Scripts -->

        {{ ssk:footer }}
        {{ stack:bottom }}
    </body>
</html>
```

### Tags
Getting your site's SEO data onto the page relies on a few tags being present in your theme templates:

- `{{ ssk:head }}` - Contains meta tags and other information, this tag should be inside of the `<head>` element (in place of any title or meta tags)
- `{{ ssk:body }}` - Contains scripts that need to be inside of the `<body>` element, it should be placed after the opening `<body>` tag.
- `{{ ssk:footer }}` - Contains any scripts that need to be included at the end of the page, it should be placed towards the end of page along with any other scripts you have in the footer.
- `{{ ssk:manifests }}` - Contains data about manifests
- `{{ ssk:data }}` - Contains all data

**Examples**

```html
{{ ssk:data }}{{ logo }}{{ /ssk:data }}
```

```html
<ul>
    {{ ssk:socials }}
        <li><a href="{{ url }}">{{ social_icon }}</a></li>
    {{ /ssk:socials }}
</ul>
```

```html
<ul>
    {{ ssk:socials-seo }}
        <li><a href="{{ url }}">{{ social_icon }}</a></li>
    {{ /ssk:socials-seo }}
</ul>
```
**ViewModel**

You can inject this view model into the YAML collection config to have data more concisely :

```yaml
inject:
  view_model: Michaelravedoni\StatamicSiteKit\ViewModels\StatamicSiteKit
```
```html
{{ ssk:informations:logo }}
```
This will work only on the injected collection entries.

## Sitemap

XML Sitemaps will get automatically generated for your site, the default url for the sitemap is `<your-site-address>/sitemap.xml`, however you are welcome to turn this off by heading to SEO > Sitemap and toggling "Enable Sitemap?" off.

The priority and change frequency can be configured on a per-page basis under the 'SEO' section.

Individual collections / taxonomies can be excluded from the sitemap with the settings under SEO > Sitemap.

## Update Git repository from live

You can commit and push the modified files from the live website with theses commands. Note thate only the `paths` array in `config/statamic/git.php` and note `.gitignore`ed will be taken into consideration.

```bash
php artisan git:update-dry
php artisan git:update
```

```bash
https://SITE.TLD/run/git-update-dry
https://SITE.TLD/run/git-update
```

## Development

Add this Composer repository to your project's root `composer.json` file:

``` json
{
    "repositories": [{
        "type": "path",
        "url": "addons/michaelravedoni/statamic-site-kit"
    }]
}
```

Run the following command from your project root:

``` bash
composer require michaelravedoni/statamic-site-kit:dev-main
```

# Install & push on production

## Configuration

Run the following command from your project root:
``` bash
composer require laravel/envoy --dev
```

Add these lines at your local `.env` file :
```
ENVOY_SERVER=user@example.com
ENVOY_REPOSITORY=git@github.com:michaelravedoni/REPOSITORY.git
ENVOY_PATH=/home/clients/PATH/sites
ENVOY_HEALTH_CHECK=https://example.com.ch
ENVOY_PROJECT=example
```

Create a file `Envoy.blade.php` at your project root containing :
``` php
@import('vendor/michaelravedoni/statamic-site-kit/Envoy.blade.php')
```

Create a file `live.sh` at your project root containing all live script. For example :
``` bash
#!/bin/sh

# Turn on maintenance mode
echo 'Command: down'
php artisan down --secret="1630542a-246b-4b66-afa1-dd72a4c43515"

# Clean production server without saving live changes
# git reset --hard
# git clean -df

# Pushing live changes
# git add .
# git commit -m "[Manual commit]: Update from live"
# git push

# Pull from the origin
git pull origin

# Install/update composer dependecies
echo 'Command: composer'
composer install --verbose --prefer-dist --no-progress --no-interaction --no-dev --optimize-autoloader

# Run generate key
# echo 'Command: key'
# php artisan key:generate

# Run storage link
echo 'Command: storage'
php artisan storage:link

# Run database migrations
# echo 'Command: migrate'
# php artisan migrate --force --seed
# --force  Required to run when in production.

# Run database migrations with seed
# echo 'Command: migrate'
# php artisan migrate --force
# --force  Required to run when in production.

# Run database migrations with a new database
# echo 'Command: migrate'
# php artisan migrate:fresh --seed --force

# Clear caches
echo 'Command: cache'
php artisan cache:clear

# Laravel clear expired password reset tokens
# php artisan auth:clear-resets

# Laravel clear and cache routes
# php artisan route:cache

# Laravel clear and cache config
# php artisan config:cache

# Laravel clear and cache views
# php artisan view:cache

echo 'Command: statamic'
# Statamic addons
# php please addons:discover

# Statamic assets
# php please assets:generate-presets
# php please assets:meta
# php please glide:clear

# Statamic stache
php please stache:clear
# php please stache:doctor
# php please stache:refresh
php please stache:warm

# Install node modules
# npm install

# Build assets using Laravel Mix
# npm run production

# Start Cronless schedule
# php artisan schedule:run-cronless

# Turn off maintenance mode
echo 'Command: up'
php artisan up

echo '🚀 Live !'
```

## Commands
``` bash
envoy run check_ssh_key
envoy run check_github_ssh_connection
envoy run install
envoy run origin_fetch
envoy run live_push
envoy run live_push_dry
envoy run live
envoy run health_check
```


Check theses pages for more informations or more tips :

- [MR Sheet](https://gist.github.com/michaelravedoni/4f5d8ccec3a81b63cf4259406b466e21)
- [Deployer](https://deployer.org)
- [Run script on remote 1](https://stackoverflow.com/questions/305035/how-to-use-ssh-to-run-a-local-shell-script-on-a-remote-machine)
- [Run script on remote 2](https://gist.github.com/checkaayush/7271e96e0be409a05a9f)

