<?php

namespace Michaelravedoni\StatamicSiteKit\Controllers\CP\Seo;

use Statamic\CP\Breadcrumbs;
use Statamic\Facades\Site;
use Michaelravedoni\StatamicSiteKit\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\MarketingBlueprint;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Controllers\CP\Contracts\Publishable;

class MarketingController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk seo marketing');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.seo'), 'url' => cp_route('statamic-site-kit.seo.home')],
            ['text' => __('statamic-site-kit::marketing.index'), 'url' => cp_route('statamic-site-kit.seo.marketing.index')],
        ]);

        return view('statamic-site-kit::cp.seo.marketing', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::marketing.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk seo marketing');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());

        StatamicSiteKitGlobalsUpdated::dispatch('marketing');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return MarketingBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('marketing', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('marketing', Site::selected(), $data);
    }
}
