<?php

namespace Michaelravedoni\StatamicSiteKit\Controllers\CP\Settings;

use Statamic\Facades\File;
use Statamic\Facades\Site;
use Statamic\CP\Breadcrumbs;
use Statamic\Facades\GlobalSet;
use Illuminate\Support\Facades\Http;
use Michaelravedoni\StatamicSiteKit\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Controllers\CP\Contracts\Publishable;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings\ManifestsBlueprint;

class ManifestsController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk settings manifests');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.settings'), 'url' => cp_route('statamic-site-kit.settings.home')],
            ['text' => __('statamic-site-kit::manifests.index'), 'url' => cp_route('statamic-site-kit.settings.manifests.index')],
        ]);

        return view('statamic-site-kit::cp.settings.manifests', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::manifests.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk settings manifests');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());

        /* Generate files */
        $data = $fields->process()->values()->toArray();
        $webmanifestResponse = Http::get(url('').'/generate/site.webmanifest')->body();
        $browserconfigResponse = Http::get(url('').'/generate/browserconfig.xml')->body();
        File::put(public_path().'/humans.txt', data_get($data, 'humans_manifest'));
        File::put(public_path().'/analytics.txt', data_get($data, 'analytics_manifest'));
        File::put(public_path().'/.well-known/security.txt', data_get($data, 'security_manifest'));
        File::put(public_path().'/site.webmanifest', $webmanifestResponse);
        File::put(public_path().'/browserconfig.xml', $browserconfigResponse);

        File::put(public_path().'/test.txt', json_encode($data));

        StatamicSiteKitGlobalsUpdated::dispatch('manifests');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return ManifestsBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('manifests', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('manifests', Site::selected(), $data);
    }
}
