<?php

namespace Michaelravedoni\StatamicSiteKit\Schema\Parts;

use Spatie\SchemaOrg\Schema;
use Statamic\Facades\Asset;
use Statamic\Facades\Config;
use Statamic\Facades\Site;
use Statamic\Facades\URL;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Schema\SchemaIds;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\Contracts\SchemaPart;

class SiteOwner implements SchemaPart
{
    public function __construct($context = [])
    {
        $this->context = $context;
    }

    public function data()
    {
        $type = $this->context->get('structured_data_type')->raw();
        if ($type === 'organization') {
            $owner = Schema::organization();
            $owner->name($this->context->get('structured_data_target_name')->raw());
            $logo = $this->context->get('structured_data_logo')->value();
            if (!empty($logo)) {
                $logoObject = Schema::imageObject();
                $logoObject->url($logo->absoluteUrl());
                $logoObject->width($logo->width());
                $logoObject->height($logo->height());
                $owner->logo($logoObject);
            }
        } elseif ($type === 'local_business') {
            $owner = Schema::localBusiness();
            $owner->name($this->context->get('structured_data_target_name')->raw());
            $logo = $this->context->get('structured_data_logo')->value();
            if (!empty($logo)) {
                $logoObject = Schema::imageObject();
                $logoObject->url($logo->absoluteUrl());
                $logoObject->width($logo->width());
                $logoObject->height($logo->height());
                $owner->logo($logoObject);
            }
            $owner->geo(Schema::GeoCoordinates()
                ->latitude($this->context->get('geo_latitude')->raw())
                ->longitude($this->context->get('geo_longitude')->raw())
            );
        } else {
            $owner = Schema::person();
            $owner->name($this->context->get('structured_data_target_name')->raw());
        }
        $owner->setProperty('@id', self::id());
        $owner->url(URL::makeAbsolute(Config::getSiteUrl()));

        // Social settings
        $social_settings = StatamicSiteKitStorage::getYaml('social', Site::current(), true);

        $social_urls = \collect($social_settings->get('seo_social_links', []))
            ->map(function ($social_item) {
                return $social_item['url'] ?? null;
            })
            ->filter();

        if ($social_urls->count() > 0) {
            $owner->sameAs(
                $social_urls->toArray()
            );
        }

        // Informations
        $owner->address(Schema::PostalAddress()
            ->addressLocality($this->context->get('locality')->raw())
            ->streetAddress($this->context->get('address')->raw())
            ->postalCode($this->context->get('postal_code')->raw())
            ->addressCountry($this->context->get('country')->raw())
        );
        $owner->telephone($this->context->get('phone')->raw());
        $owner->email($this->context->get('email')->raw());
        $owner->description($this->context->get('description')->raw());

        return $owner;
    }

    /**
     * Return the ID of the site owner
     */
    public static function id()
    {
        return URL::makeAbsolute(Config::getSiteUrl()) . SchemaIds::SITE_OWNER;
    }
}
