<?php

namespace Michaelravedoni\StatamicSiteKit\Commands;

use Gitonomy\Git\Repository;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class UpdateGit extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'git:update';

    /**
     * The console command description.
     */
    protected $description = 'Automatically updates adds, commits and pushes any changes';

    /**
     * Staged files
     */
    public $stagedFiles = [];

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $repository = new Repository('.git');
        $paths = config('statamic.git.paths');

        foreach ($paths as $path) {
            //$output = shell_exec("git status -s {$path}");
            $output = $repository->run('status', ['--short', $path]);

            if ($output) {
                $this->line($output);
                //shell_exec("git add {$path}");
                $repository->run('add', [$path]);

                $this->stagedFiles[] = $this->trimFileName($output);
            }
        }

        $this->stagedFiles = array_flatten($this->stagedFiles);

        if (! empty($this->stagedFiles)) {
            $message = $this->commitMessage();

            $output = $repository->run('commit', ['-m', $message]);
            $output ? $this->line($output) : null;

            $output = $repository->run('push', ['-f']);
            $output ? $this->line($output) : null;

            $this->newLine();
            $this->info('----------');
            $this->info('| Pushed |');
            $this->info('----------');
            $this->newLine();

        } else {
            $this->newLine();
            $this->info('-------------------');
            $this->info('| Nothing to push |');
            $this->info('-------------------');
            $this->newLine();
            $this->line('Run `git:update-dry` for more informations.');
            $this->newLine();
        }

        return 0;
    }

    public function trimFileName(string $output): array
    {
        $files = [];

        $lines = explode("\n", $output);

        foreach ($lines as $line) {
            $line = trim($line);

            if (strlen($line)) {
                $files[] = basename(substr($line, 2));
            }
        }

        return $files;
    }

    public function commitMessage(): string
    {
        $stagedFileCount = count($this->stagedFiles);

        return Str::of("[Auto-commit]: Updated from live {$this->stagedFiles[0]}")
            ->when(count($this->stagedFiles) > 1, function ($message) use ($stagedFileCount) {
                return $message->append(' and '.$stagedFileCount - 1 .' other files');
            })->toString();
    }
}
