<?php

namespace Michaelravedoni\StatamicSiteKit\Controllers\Web;

use Illuminate\Routing\Controller;
use Statamic\Facades\GlobalSet;

class AnalyticsController extends Controller
{
    public function show()
    {
        abort_unless(config('statamic-site-kit.analytics.enabled'), 404);

        $data = GlobalSet::findByHandle('info')->inCurrentSite()->get('analytics_manifest');

        $contents = view('statamic-site-kit::manifests.analytics', $data);

        $response = response()
            ->make($contents)
            ->header('Content-Type', 'text/plain');

        return $response;
    }
}
