<?php

namespace Michaelravedoni\StatamicSiteKit\Controllers\Web;

use Illuminate\Routing\Controller;
use Statamic\Facades\GlobalSet;

class SecurityController extends Controller
{
    public function show()
    {
        abort_unless(config('statamic-site-kit.security.enabled'), 404);

        $data = GlobalSet::findByHandle('info')->inCurrentSite()->get('security_manifest');

        $contents = view('statamic-site-kit::manifests.security', $data);

        $response = response()
            ->make($contents)
            ->header('Content-Type', 'text/plain');

        return $response;
    }
}
