<?php

namespace Michaelravedoni\StatamicSiteKit\Parsers;

use Statamic\Facades\Blueprint;
use Statamic\Facades\YAML;

class GlobalParser
{
    public static function getValues($globalHandle)
    {
        $blueprintYaml = YAML::file(base_path('resources/blueprints/globals/'.$globalHandle.'.yaml'))->parse();
        $blueprint = Blueprint::make()->setContents($blueprintYaml);
        $valuesYaml = YAML::file(base_path('content/globals/'.$globalHandle.'.yaml'))->parse();
        $values = data_get($valuesYaml, 'data');
        $blueprintValues = $blueprint->fields()
            ->addValues($values ?: [])
            ->augment()
            ->values();
        // If only existing values
        //->only(array_keys($values));

        return $blueprintValues;
    }
}
