<?php

namespace Michaelravedoni\StatamicSiteKit\Tags;

use Michaelravedoni\StatamicSiteKit\Parsers\GlobalParser;
use Michaelravedoni\StatamicSiteKit\Schema\SchemaGraph;
use Statamic\Tags\Tags;
use Statamic\View\View;

class StatamicSiteKitTags extends Tags
{
    protected static $handle = 'ssk';

    public function getData()
    {
        $info = GlobalParser::getValues('info');
        $context = collect($this->context);

        return $info->merge($context);
    }

    /**
     * Return the <head /> tag content required for on-page SEO
     *
     * @return string
     */
    public function head()
    {
        $data = $this->getData();

        $view = View::make('statamic-site-kit::tags.head', $data->all());

        if ($this->params->get('debug')) {
            return $view;
        }

        return preg_replace(
            [
                "/<!--(.|\s)*?-->/",
                "/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/",
            ],
            [
                '',
                "\n",
            ],
            $view
        );
    }

    /**
     * Return the schema graph object
     *
     * @return string
     */
    public function graph()
    {
        $ctx = collect($this->context);
        $graph = new SchemaGraph($ctx);

        return $graph->build();
    }
}
