<?php

namespace Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo;

use Michaelravedoni\StatamicSiteKit\Blueprints\Blueprint as StatamicSiteKitBlueprint;
use Statamic\Facades\Blueprint as StatamicBlueprint;

class MarketingBlueprint implements StatamicSiteKitBlueprint
{
    /**
     * @inheritDoc
     */
    public static function requestBlueprint()
    {
        return StatamicBlueprint::make()->setContents([
            'sections' => [
                'main' => [
                    'fields' => [
                        [
                            'handle' => 'analytics_section',
                            'field' => [
                                'type' => 'section',
                                'listable' => 'hidden',
                                'display' => __('statamic-site-kit::marketing.fields.analytics_section.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.analytics_section.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'enable_analytics_script',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::marketing.fields.enable_analytics_script.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.enable_analytics_script.instruct'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'enable_analytics_on_local_environment',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::marketing.fields.enable_analytics_on_local_environment.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.enable_analytics_on_local_environment.instruct'),
                                'width' => 50,'if' => [
                                    'enable_analytics_script' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'analytics_script',
                            'field' => [
                                'type' => 'code',
                                'display' => __('statamic-site-kit::marketing.fields.analytics_script.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.analytics_script.instruct'),
                                'width' => 100,
                                'if' => [
                                    'enable_analytics_script' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'gtm_section',
                            'field' => [
                                'type' => 'section',
                                'listable' => 'hidden',
                                'display' => __('statamic-site-kit::marketing.fields.gtm_section.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.gtm_section.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'enable_gtm_script',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::marketing.fields.enable_gtm_script.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.enable_gtm_script.instruct'),
                                'width' => 33,
                            ],
                        ],
                        [
                            'handle' => 'gtm_identifier',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::marketing.fields.gtm_identifier.display'),
                                'instructions' => __('statamic-site-kit::marketing.fields.gtm_identifier.instruct'),
                                'width' => 66,
                                'if' => [
                                    'enable_gtm_script' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'site_verification_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::marketing.fields.site_verification_section.display'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'google_verification_code',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::marketing.fields.google_verification_code.display'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'bing_verification_code',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::marketing.fields.bing_verification_code.display'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'yandex_verification_code',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::marketing.fields.yandex_verification_code.display'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'baidu_verification_code',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::marketing.fields.baidu_verification_code.display'),
                                'width' => 50,
                            ],
                        ],
                    ],
                ],
            ],
        ]);
    }
}
