@setup
	require __DIR__.'/vendor/autoload.php';
	$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
	try {
		$dotenv->load();
		$dotenv->required(['ENVOY_SERVER', 'ENVOY_REPOSITORY', 'ENVOY_PATH', 'ENVOY_PROJECT'])->notEmpty();
	} catch ( Exception $e )  {
		echo $e->getMessage();
		exit;
	}

	$php = $_ENV['ENVOY_PHP_CMD'] ?? 'php';
	$composer = $_ENV['ENVOY_COMPOSER_CMD'] ?? 'composer';
	$php_fpm = $_ENV['ENVOY_PHP_FPM'] ?? null;
	$server = $_ENV['ENVOY_SERVER'] ?? null;
	$repo = $_ENV['ENVOY_REPOSITORY'] ?? null;
	$path = $_ENV['ENVOY_PATH'] ?? null;
	$project = $_ENV['ENVOY_PROJECT'] ?? null;
	$slack = $_ENV['ENVOY_SLACK_WEBHOOK'] ?? null;
	$healthUrl = $_ENV['ENVOY_HEALTH_CHECK'] ?? null;
	$restartQueue = $_ENV['ENVOY_RESTART_QUEUE'] ?? false;

	if ( substr($path, 0, 1) !== '/' ) throw new Exception('Careful - your deployment path does not begin with /');

	$date = ( new DateTime )->format('YmdHis');
	$env = isset($env) ? $env : "production";
	$branch = isset($branch) ? $branch : "main";
	$path = rtrim($path, '/');
	$releases = $path.'/releases';
	$release = $releases.'/'.$date;

	// arguments : --nlpto (no-live-push-to-origin) --nlffo (no-live-fetch-from-origin)
@endsetup

@servers(['production' => $server, 'local' => '127.0.0.1'])


@task('check_ssh_key', ['on' => 'production'])
ls -al ~/.ssh
@endtask

@task('check_github_ssh_connection', ['on' => 'production'])
ssh -T git@github.com
@endtask

@task('live_push', ['on' => 'production'])
@if (!$nlpto)
	echo 'Run live_push on production server'
	cd {{ $path }}/{{ $project }}
	php artisan git:update
@endif
@endtask

@task('live_push_dry', ['on' => 'production'])
echo 'Run live_push_dry on production server'
cd {{ $path }}/{{ $project }}
php artisan git:update-dry
@endtask

@task('origin_fetch', ['on' => 'local'])
@if (!$nlffo)
	echo 'Run origin_fetch on local server'
	git fetch origin {{ $branch }}
@endif
@endtask

@task('install', ['on' => 'production'])
echo 'Run install on production server'
if [ ! -d {{ $path }}/{{ $project }} ]; then
    cd {{ $path }}
    git clone --branch={{ $branch }} {{ $repo }} {{ $project }}
    echo "Repository cloned"
    cd {{ $project }}
    echo "Installing composer dependencies"
    composer install --no-interaction --prefer-dist --optimize-autoloader --no-dev
    cp .env.example .env
    echo "Environment file set up"
    echo "Run generate key"
    php artisan key:generate
    echo "Edit .env then run 'envoy run health_check'."
else
    echo "Project path already exists!"
fi
@endtask

@story('live', ['on' => 'production'])
    live_push
    live_start
    live_script
    health_check
@endstory

@task('live_start', ['on' => 'production'])
echo 'Run live_start on production server'
if [ -d {{ $path }}/{{ $project }} ]; then
    cd {{ $path }}/{{ $project }}
else
    echo "Project path do not exists!"
fi
@endtask

@task('live_script', ['on' => 'production'])
echo 'Run live_script on production server'
cd {{ $path }}/{{ $project }}
sh ./live.sh
@endtask

@task('health_check', ['on' => 'local'])
	echo 'Run health_check on production server'
	@if ( ! empty($healthUrl) )
		if [ "$(curl --write-out "%{http_code}\n" --silent --output /dev/null {{ $healthUrl }})" == "200" ]; then
			printf "\033[0;32mHealth check to {{ $healthUrl }} OK\033[0m\n"
		else
			printf "\033[1;31mHealth check to {{ $healthUrl }} FAILED\033[0m\n"
		fi
	@else
		echo "No health check set"
	@endif
@endtask