<?php

namespace Michaelravedoni\StatamicSiteKit\ViewModels;

use Statamic\View\ViewModel;
use Statamic\Facades\Site;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Facades\PageDataParser;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\DefaultsBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\GeneralBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\MarketingBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\SocialBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\OnPageSeoBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings\InformationsBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings\ManifestsBlueprint;

class StatamicSiteKit extends ViewModel
{
    public function data(): array
    {

        $informations = PageDataParser::getValues('informations', new InformationsBlueprint);
        $manifests = PageDataParser::getValues('manifests', new ManifestsBlueprint);

        return [
            'ssk' => [
                'infos' => $informations,
                'manifests' => $manifests,
            ],
        ];
    }
}
