<?php

namespace Michaelravedoni\StatamicSiteKit\Schema;

use Michaelravedoni\StatamicSiteKit\Parsers\GlobalParser;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\Breadcrumbs;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\SiteOwner;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\WebPage;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\WebSite;
use Spatie\SchemaOrg\Graph;

class SchemaGraph
{
    /**
     * @var \Illuminate\Support\Collection
     */
    protected $context;

    /**
     * @var \Illuminate\Support\Collection
     */
    protected $globals;

    /**
     * @var Graph
     */
    protected $graph;

    public function __construct($context)
    {
        $this->context = $context;
        $this->graph = new Graph;

        $informationsData = GlobalParser::getValues('info');

        $this->globals = $informationsData;

        $this->populateData();
    }

    private function populateData()
    {
        $siteOwner = new SiteOwner($this->globals);
        $webSite = new WebSite($this->globals);
        $webPage = new WebPage($this->context);
        $webPageData = $webPage->data();

        // // If breadcrumbs are enabled - add them to the graph
        if (! empty($this->globals->get('enable_structured_data_breadcrumbs', 0)) && $this->context->get('url', '') !== '/') {
            $breadcrumbs = new Breadcrumbs;
            $webPageData->breadcrumb($breadcrumbs->data());
        }

        $this->graph->add($siteOwner->data());
        $this->graph->add($webSite->data());
        $this->graph->add($webPageData);
    }

    public function build()
    {
        return $this->graph;
    }
}
