<?php

Route::namespace('\Michaelravedoni\StatamicSiteKit\Http\Controllers\CP')
    ->prefix('statamic-site-kit')
    ->name('statamic-site-kit.')
    ->group(function () {

        Route::redirect('/', 'statamic-site-kit/settings/informations')->name('home');

        // SEO
        Route::namespace('Seo')
        ->name('seo.')
        ->prefix('seo')
        ->group(function () {

            Route::redirect('/', 'seo/general')->name('home');

            Route::resource('general', 'GeneralController')->only([
                'index', 'store',
            ]);

            Route::resource('sitemap', 'SitemapController')->only([
                'index', 'store',
            ]);

            Route::resource('marketing', 'MarketingController')->only([
                'index', 'store',
            ]);

            Route::resource('social', 'SocialController')->only([
                'index', 'store',
            ]);

            Route::resource('defaults', 'DefaultsController')->only([
                'index', 'edit', 'update',
            ]);
        });

        // Settings
        Route::namespace('Settings')
        ->name('settings.')
        ->prefix('settings')
        ->group(function () {
            Route::redirect('/', 'settings/informations')->name('home');

            // Informations
            Route::resource('informations', 'InformationsController')->only([
                'index', 'store',
            ]);
            // Manifests
            Route::resource('manifests', 'ManifestsController')->only([
                'index', 'store',
            ]);
        });
});
