<?php

use Statamic\Facades\Site;
use Statamic\Facades\URL;

Route::namespace('\Michaelravedoni\StatamicSiteKit\Http\Controllers\Web')
    ->name('ssk-xml-sitemap')
    ->group(function () {
        Route::get('sitemap.xml', 'SitemapController@index')
            ->name('index');
        Route::get('sitemap_{handle}.xml', 'SitemapController@single')
            ->name('single');
        Route::get('ssk-sitemap.xsl', 'SitemapController@xsl')
            ->name('xsl');

        // Add sitemap routes for non-domain-level multisites
        $roots = Site::all()->map(function ($site) {
            return URL::makeRelative($site->url());
        })->filter(function ($root) {
            return $root !== '/';
        })->unique();

        $roots->each(function ($root) {
            Route::get("${root}/sitemap.xml", 'SitemapController@index')
                ->name("${root}.index");
            Route::get("${root}/sitemap_{handle}.xml", 'SitemapController@single')
                ->name("${root}.single");
            Route::get("${root}/ssk-sitemap.xsl", 'SitemapController@xsl')
                ->name("${root}.xsl");
        });
    });

// Manifests
Route::statamic('/site.webmanifest', 'statamic-site-kit::manifests.manifest', [
    'layout' => null,
    'content_type' => 'application/json'
]);

Route::statamic('/humans.txt', 'statamic-site-kit::manifests.humans', [
    'layout' => null,
    'content_type' => 'text/plain'
]);

Route::statamic('/analytics.txt', 'statamic-site-kit::manifests.analytics', [
    'layout' => null,
    'content_type' => 'text/plain'
]);

Route::statamic('/.well-known/security.txt', 'statamic-site-kit::manifests.security', [
    'layout' => null,
    'content_type' => 'text/plain'
]);


Route::statamic('/browserconfig.xml', 'statamic-site-kit::manifests.browserconfig', [
    'layout' => null,
    'content_type' => 'application/xml'
]);
