<?php

namespace Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Seo;

use Statamic\CP\Breadcrumbs;
use Statamic\Facades\Site;
use Statamic\Facades\User;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\GeneralBlueprint;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Contracts\Publishable;

class GeneralController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk seo general');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.seo'), 'url' => cp_route('statamic-site-kit.seo.home')],
            ['text' => __('statamic-site-kit::general.index'), 'url' => cp_route('statamic-site-kit.seo.general.index')],
        ]);

        return view('statamic-site-kit::cp.seo.general', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::general.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk seo general');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());

        StatamicSiteKitGlobalsUpdated::dispatch('general');
    }

    /**
     * Redirects from the top level SEO nav item
     */
    public function settingsRedirect()
    {
        $groups = collect([
            'general',
            'marketing',
            'defaults',
            'social',
            'sitemap',
        ]);

        $first_group = $groups->filter(function ($group) {
            return User::current()->can("view ssk seo {$group}");
        })->first();

        if (!empty($first_group)) {
            return redirect()->route("statamic.cp.statamic-site-kit.{$first_group}.index");
        }

        // If no permissions are found use Statamic to inform the user
        $this->authorize('view ssk seo general');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return GeneralBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('general', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('general', Site::selected(), $data);
    }
}
