<?php

namespace Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Seo;

use Statamic\CP\Breadcrumbs;
use Statamic\Facades\Site;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\SitemapBlueprint;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Contracts\Publishable;

class SitemapController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk seo sitemap');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.seo'), 'url' => cp_route('statamic-site-kit.seo.home')],
            ['text' => __('statamic-site-kit::sitemap.index'), 'url' => cp_route('statamic-site-kit.seo.sitemap.index')],
        ]);

        return view('statamic-site-kit::cp.seo.sitemap', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::sitemap.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk seo sitemap');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());

        StatamicSiteKitGlobalsUpdated::dispatch('sitemap');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return SitemapBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('sitemap', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('sitemap', Site::selected(), $data);
    }
}
