<?php

namespace Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Seo;

use Statamic\CP\Breadcrumbs;
use Statamic\Facades\Site;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\SocialBlueprint;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Contracts\Publishable;

class SocialController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk seo social');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.seo'), 'url' => cp_route('statamic-site-kit.seo.home')],
            ['text' => __('statamic-site-kit::social.index'), 'url' => cp_route('statamic-site-kit.seo.social.index')],
        ]);

        return view('statamic-site-kit::cp.seo.social', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::social.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk seo social');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());

        StatamicSiteKitGlobalsUpdated::dispatch('social');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return SocialBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('social', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('social', Site::selected(), $data);
    }
}
