<?php

namespace Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Settings;

use Statamic\CP\Breadcrumbs;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings\InformationsBlueprint;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Http\Controllers\CP\Contracts\Publishable;
use Statamic\Facades\Site;
use Statamic\Facades\GlobalSet;

class InformationsController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk settings informations');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.settings'), 'url' => cp_route('statamic-site-kit.settings.home')],
            ['text' => __('statamic-site-kit::informations.index'), 'url' => cp_route('statamic-site-kit.settings.informations.index')],
        ]);

        return view('statamic-site-kit::cp.settings.informations', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::informations.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk settings informations');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());
        $this->putDataInGlobal($fields->process()->values()->toArray());

        StatamicSiteKitGlobalsUpdated::dispatch('informations');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return InformationsBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('informations', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('informations', Site::selected(), $data);
    }

    /**
     * @inheritdoc
     */
    public function putDataInGlobal($data)
    {
        $currentSite = Site::current();
        $set = GlobalSet::findByHandle('informations');
        if (empty($set)) {
            $set = GlobalSet::make('informations')->title('Statamic Site Kit - Informations');
        }
        $variables = $set->inCurrentSite();
        if (empty($set->inCurrentSite())) {
            $variables = $set->makeLocalization($currentSite->handle());
        }
        $variables->data($data);
        $set->addLocalization($variables);
        $set->save();
    }
}
