<?php

namespace Michaelravedoni\StatamicSiteKit\Schema;

use Spatie\SchemaOrg\Graph;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo\GeneralBlueprint;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings\InformationsBlueprint;
use Michaelravedoni\StatamicSiteKit\Facades\PageDataParser;
use Michaelravedoni\StatamicSiteKit\Schema\SchemaIds;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\Breadcrumbs;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\SiteOwner;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\WebPage;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\WebSite;

class SchemaGraph
{
    /**
     * @var \Illuminate\Support\Collection
     */
    protected $context;

    /**
     * @var \Illuminate\Support\Collection
     */
    protected $globals;

    /**
     * @var Graph
     */
    protected $graph;

    public function __construct($context)
    {
        $this->context = $context;
        $this->graph = new Graph();

        $generalData = PageDataParser::getSettingsBlueprintWithValues($context, 'general', new GeneralBlueprint());
        $informationsData = PageDataParser::getSettingsBlueprintWithValues($context, 'informations', new InformationsBlueprint());

        $this->globals = $generalData->merge($informationsData);

        $this->populateData();
    }

    private function populateData()
    {
        $siteOwner = new SiteOwner($this->globals);
        $webSite = new WebSite($this->globals);
        $webPage = new WebPage($this->context);
        $webPageData = $webPage->data();

        // // If breadcrumbs are enabled - add them to the graph
        if (!empty($this->globals->get('enable_structured_data_breadcrumbs', 0)) && $this->context->get('url', '') !== '/') {
            $breadcrumbs = new Breadcrumbs();
            $webPageData->breadcrumb($breadcrumbs->data());
        }

        $this->graph->add($siteOwner->data());
        $this->graph->add($webSite->data());
        $this->graph->add($webPageData);
    }

    public function build()
    {
        return $this->graph;
    }
}
