<?php

namespace Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo;

use Michaelravedoni\StatamicSiteKit\Blueprints\Blueprint as StatamicSiteKitBlueprint;
use Statamic\Facades\Blueprint as StatamicBlueprint;

class GeneralBlueprint implements StatamicSiteKitBlueprint
{
    /**
     * @inheritDoc
     */
    public static function requestBlueprint()
    {
        return StatamicBlueprint::make()->setContents([
            'sections' => [
                'main' => [
                    'fields' => [
                        [
                            'handle' => 'titles_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::general.fields.titles_section.display'),
                                'instructions' => __('statamic-site-kit::general.fields.titles_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'title_separator',
                            'field' => [
                                'type' => 'select',
                                'display' => __('statamic-site-kit::general.fields.title_separator.display'),
                                'instructions' => __('statamic-site-kit::general.fields.title_separator.instruct'),
                                'default' => '|',
                                'options' => [
                                    '|',
                                    '-',
                                    '~',
                                    '•',
                                    '/',
                                    '//',
                                    '»',
                                    '«',
                                    '>',
                                    '<',
                                    '*',
                                    '+',
                                ],
                                'width' => 33,
                            ],
                        ],
                        [
                            'handle' => 'site_name',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::general.fields.site_name.display'),
                                'instructions' => __('statamic-site-kit::general.fields.site_name.instruct'),
                                'width' => 66,
                            ],
                        ],
                        [
                            'handle' => 'favicon_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::general.fields.favicon_section.display'),
                                'instructions' => __('statamic-site-kit::general.fields.favicon_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'global_favicon',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::general.fields.global_favicon.display'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                            ],
                        ],
                        [
                            'handle' => 'global_favicon_svg',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::general.fields.global_favicon_svg.display'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                            ],
                        ],
                        [
                            'handle' => 'structured_data_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::general.fields.structured_data_section.display'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'structured_data_type',
                            'field' => [
                                'type' => 'radio',
                                'display' => __('statamic-site-kit::general.fields.structured_data_type.display'),
                                'instructions' => __('statamic-site-kit::general.fields.structured_data_type.instruct'),
                                'default' => 'company',
                                'inline' => true,
                                'options' => [
                                    'organization' => 'Organization',
                                    'person' => 'Person',
                                    'local_business' => 'LocalBusiness',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'structured_data_target_name',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::general.fields.structured_data_target_name.display'),
                                'instructions' => __('statamic-site-kit::general.fields.structured_data_target_name.instruct'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'structured_data_logo',
                            'field' => [
                                'type' => 'assets',
                                'max_files' => 1,
                                'restrict' => false,
                                'width' => 50,
                                'display' => __('statamic-site-kit::general.fields.structured_data_logo.display'),
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                                'if_any' => [
                                    'structured_data_type' => 'contains_any organization,local_business',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'custom_structured_data',
                            'field' => [
                                'type' => 'code',
                                'mode' => 'json',
                                'display' => __('statamic-site-kit::general.fields.custom_structured_data.display'),
                                'instructions' => __('statamic-site-kit::general.fields.custom_structured_data.instruct'),
                                'rows' => 10,
                            ],
                        ],
                        [
                            'handle' => 'structured_data_breadcrumbs_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::general.fields.structured_data_breadcrumbs_section.display'),
                                'instructions' => __('statamic-site-kit::general.fields.structured_data_breadcrumbs_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'enable_structured_data_breadcrumbs',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::general.fields.enable_structured_data_breadcrumbs.display'),
                                'default' => true,
                            ],
                        ],
                        [
                            'handle' => 'no_index_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::general.fields.no_index_section.display'),
                                'instructions' => __('statamic-site-kit::general.fields.no_index_section.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'no_index_site',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::general.fields.no_index_site.display'),
                                'instructions' => __('statamic-site-kit::general.fields.no_index_site.instruct'),
                            ],
                        ],
                    ],
                ],
            ],
        ]);
    }
}
