<?php

namespace Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo;

use Michaelravedoni\StatamicSiteKit\Blueprints\Blueprint as StatamicSiteKitBlueprint;
use Statamic\Facades\Blueprint as StatamicBlueprint;

class OnPageSeoBlueprint implements StatamicSiteKitBlueprint
{
    /**
     * @inheritDoc
     */
    public static function requestBlueprint()
    {
        return StatamicBlueprint::make()->setContents([
            'sections' => [
                'main' => [
                    'fields' => [
                        [
                            'handle' => 'meta_section',
                            'field' => [
                                'type' => 'section',
                                'listable' => 'hidden',
                                'display' => __('statamic-site-kit::onpage.fields.meta_section.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.meta_section.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'meta_title',
                            'field' => [
                                'type' => 'ssk_meta_title',
                                'display' => __('statamic-site-kit::onpage.fields.meta_title.display'),
                                'localizable' => true,
                                'antlers' => true,
                            ],
                        ],
                        [
                            'handle' => 'meta_description',
                            'field' => [
                                'type' => 'ssk_meta_description',
                                'display' => __('statamic-site-kit::onpage.fields.meta_description.display'),
                                'localizable' => true,
                                'antlers' => true,
                            ],
                        ],
                        [
                            'handle' => 'google_search_preview',
                            'field' => [
                                'type' => 'ssk_google_preview',
                                'display' => __('statamic-site-kit::onpage.fields.google_preview.display'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'use_meta_keywords',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::onpage.fields.use_meta_keywords.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.use_meta_keywords.instruct'),
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'meta_keywords',
                            'field' => [
                                'type' => 'taggable',
                                'display' => __('statamic-site-kit::onpage.fields.meta_keywords.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.meta_keywords.instruct'),
                                'localizable' => true,
                                'if' => [
                                    'use_meta_keywords' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'urls_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::onpage.fields.urls_section.display'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'canonical_url',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::onpage.fields.canonical_url.display'),
                                'listable' => 'hidden',
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'localized_urls',
                            'field' => [
                                'type' => 'grid',
                                'display' => __('statamic-site-kit::onpage.fields.localized_urls.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.localized_urls.instruct'),
                                'listable' => 'hidden',
                                'add_row' => __('statamic-site-kit::onpage.fields.localized_urls.add_row'),
                                'localizable' => true,
                                'fields' => [
                                    [
                                        'handle' => 'locale',
                                        'field' => [
                                            'type' => 'text',
                                            'display' => __('statamic-site-kit::onpage.fields.localized_urls.fields.locale.display'),
                                            'placeholder' => 'fr-fr',
                                        ],
                                    ],
                                    [
                                        'handle' => 'url',
                                        'field' => [
                                            'type' => 'text',
                                            'display' => __('statamic-site-kit::onpage.fields.localized_urls.fields.url.display'),
                                            'placeholder' => 'mysite.com/fr/',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        [
                            'handle' => 'indexing_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::onpage.fields.indexing_section.display'),
                            ],
                        ],
                        [
                            'handle' => 'no_index_page',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::onpage.fields.no_index_page.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.no_index_page.instruct'),
                                'width' => 50,
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'no_follow_links',
                            'field' => [
                                'type' => 'toggle',
                                'display' => __('statamic-site-kit::onpage.fields.no_follow_links.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.no_follow_links.instruct'),
                                'width' => 50,
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'sitemap_priority',
                            'field' => [
                                'type' => 'select',
                                'display' => __('statamic-site-kit::onpage.fields.sitemap_priority.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.sitemap_priority.instruct'),
                                'default' => '0.5',
                                'width' => 50,
                                'localizable' => true,
                                'options' => [
                                    '0.0',
                                    '0.1',
                                    '0.2',
                                    '0.3',
                                    '0.4',
                                    '0.5',
                                    '0.6',
                                    '0.7',
                                    '0.8',
                                    '0.9',
                                    '1.0',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'sitemap_changefreq',
                            'field' => [
                                'type' => 'select',
                                'display' => __('statamic-site-kit::onpage.fields.sitemap_changefreq.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.sitemap_changefreq.instruct'),
                                'default' => 'daily',
                                'width' => 50,
                                'localizable' => true,
                                'options' => [
                                    'always',
                                    'hourly',
                                    'daily',
                                    'weekly',
                                    'monthly',
                                    'yearly',
                                    'never',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'share_section_og',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::onpage.fields.share_section_og.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.share_section_og.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'og_title',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::onpage.fields.og_title.display'),
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'og_description',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::onpage.fields.og_description.display'),
                                'localizable' => true,
                                'antlers' => true,
                            ],
                        ],
                        [
                            'handle' => 'og_image',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::onpage.fields.og_image.display'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'share_section_twitter',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::onpage.fields.share_section_twitter.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.share_section_twitter.instruct'),
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'override_twitter_settings',
                            'field' => [
                                'type' => 'toggle',
                                'display' => 'Override the twitter share settings for this page',
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'twitter_title',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::onpage.fields.twitter_title.display'),
                                'localizable' => true,
                                'if' => [
                                    'override_twitter_settings' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'twitter_description',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::onpage.fields.twitter_description.display'),
                                'localizable' => true,
                                'antlers' => true,
                                'if' => [
                                    'override_twitter_settings' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'override_twitter_card_settings',
                            'field' => [
                                'type' => 'toggle',
                                'display' => 'Override the twitter card settings for this page',
                                'localizable' => true,
                                'if' => [
                                    'override_twitter_settings' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'twitter_card_type_page',
                            'field' => [
                                'type' => 'select',
                                'display' => __('statamic-site-kit::onpage.fields.twitter_card_type_page.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.twitter_card_type_page.instruct'),
                                'localizable' => true,
                                'default' => 'summary',
                                'width' => 50,
                                'options' => [
                                    'summary' => 'Summary Card',
                                    'summary_large_image' => 'Summary Card with Large Image',
                                ],
                                'if' => [
                                    'override_twitter_card_settings' => 'equals true',
                                    'override_twitter_settings' => 'equals true',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'twitter_summary_image',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::onpage.fields.twitter_summary_image.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.twitter_summary_image.instruct'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                                'localizable' => true,
                                'if' => [
                                    'override_twitter_settings' => 'equals true',
                                    'override_twitter_card_settings' => 'equals true',
                                    'twitter_card_type_page' => 'equals summary',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'twitter_summary_large_image',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::onpage.fields.twitter_summary_large_image.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.twitter_summary_large_image.instruct'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                                'localizable' => true,
                                'if' => [
                                    'override_twitter_settings' => 'equals true',
                                    'override_twitter_card_settings' => 'equals true',
                                    'twitter_card_type_page' => 'equals summary_large_image',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'scripts_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::onpage.fields.scripts_section.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.scripts_section.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'head_snippets',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::onpage.fields.head_snippets.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.head_snippets.instruct'),
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'footer_snippets',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::onpage.fields.footer_snippets.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.footer_snippets.instruct'),
                                'localizable' => true,
                            ],
                        ],
                        [
                            'handle' => 'structured_data_schema',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::onpage.fields.structured_data_schema.display'),
                                'instructions' => __('statamic-site-kit::onpage.fields.structured_data_schema.instruct'),
                                'rows' => 10,
                                'localizable' => true,
                            ],
                        ],
                    ],
                ],
            ],
        ]);
    }
}
