<?php

namespace Michaelravedoni\StatamicSiteKit\Controllers\CP\Settings;

use Statamic\CP\Breadcrumbs;
use Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings\ManifestsBlueprint;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Controllers\CP\Controller;
use Michaelravedoni\StatamicSiteKit\Controllers\CP\Contracts\Publishable;
use Statamic\Facades\Site;
use Statamic\Facades\GlobalSet;

class ManifestsController extends Controller implements Publishable
{
    public function index()
    {
        $this->authorize('view ssk settings manifests');

        $data = $this->getData();

        $blueprint = $this->getBlueprint();
        $fields = $blueprint->fields()->addValues($data)->preProcess();

        $crumbs = Breadcrumbs::make([
            ['text' => __('statamic-site-kit::main.name'), 'url' => cp_route('statamic-site-kit.home')],
            ['text' => __('statamic-site-kit::main.settings'), 'url' => cp_route('statamic-site-kit.settings.home')],
            ['text' => __('statamic-site-kit::manifests.index'), 'url' => cp_route('statamic-site-kit.settings.manifests.index')],
        ]);

        return view('statamic-site-kit::cp.settings.manifests', [
            'blueprint' => $blueprint->toPublishArray(),
            'crumbs' => $crumbs,
            'meta' => $fields->meta(),
            'title' => __('statamic-site-kit::manifests.index').' | Statamic Site Kit',
            'values' => $fields->values(),
        ]);
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $this->authorize('update ssk settings manifests');

        $blueprint = $this->getBlueprint();

        $fields = $blueprint->fields()->addValues($request->all());
        $fields->validate();

        $this->putData($fields->process()->values()->toArray());

        StatamicSiteKitGlobalsUpdated::dispatch('manifests');
    }

    /**
     * @inheritdoc
     */
    public function getBlueprint()
    {
        return ManifestsBlueprint::requestBlueprint();
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        return StatamicSiteKitStorage::getYaml('manifests', Site::selected());
    }

    /**
     * @inheritdoc
     */
    public function putData($data)
    {
        return StatamicSiteKitStorage::putYaml('manifests', Site::selected(), $data);
    }
}
