<?php

namespace Michaelravedoni\StatamicSiteKit\Fieldtypes;

use Statamic\Facades\Site;
use Statamic\Fields\Fieldtype;
use Michaelravedoni\StatamicSiteKit\Facades\StatamicSiteKitStorage;

class StatamicSiteKitMetaTitleFieldtype extends Fieldtype
{
    protected static $handle = 'ssk_meta_title';
    protected $selectable = false;

    /**
     * Load the global seo settings from storage
     */
    public function preload()
    {
        $site = Site::selected();
        $data = StatamicSiteKitStorage::getYaml('general', $site, true);
        return [
            'site_name' => $data->get('site_name', ''),
            'title_separator' => $data->get('title_separator', '|'),
        ];
    }
}
