<?php

namespace Michaelravedoni\StatamicSiteKit\Listeners;

use Illuminate\Support\Facades\Cache;

class DefaultsSitemapCacheInvalidationListener
{
    public function handle(\Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitContentDefaultsSaved $event)
    {
        $defaults = $event->defaults;
        $site = $defaults->site->handle();
        $handle = $defaults->handle;

        Cache::forget("statamic-site-kit.sitemap-index.{$site}");
        Cache::forget("statamic-site-kit.sitemap-{$handle}.{$site}");
    }
}
