<?php

namespace Michaelravedoni\StatamicSiteKit\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckIfSuperToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $super_token = $request->input('super_token');
        $passed = $request->session()->get('super_token_security_passed');

        if ($super_token == config(('statamic-site-kit.super_token'))) {
            $request->session()->put('super_token_security_passed', true);
            return $next($request);
        }
        if ($passed) {
            $request->session()->put('super_token_security_passed', true);
            return $next($request);
        }

        return abort(403);
    }
}
