<?php

namespace Michaelravedoni\StatamicSiteKit\Blueprints\CP\Seo;

use Michaelravedoni\StatamicSiteKit\Blueprints\Blueprint as StatamicSiteKitBlueprint;
use Statamic\Facades\Blueprint as StatamicBlueprint;

class SocialBlueprint implements StatamicSiteKitBlueprint
{
    /**
     * @inheritDoc
     */
    public static function requestBlueprint()
    {
        return StatamicBlueprint::make()->setContents([
            'sections' => [
                'main' => [
                    'fields' => [
                        [
                            'handle' => 'social_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::social.fields.social_section.display'),
                                'instructions' => __('statamic-site-kit::social.fields.social_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'seo_social_links',
                            'field' => [
                                'type' => 'grid',
                                'display' => __('statamic-site-kit::social.fields.seo_social_links.display'),
                                'add_row' => __('statamic-site-kit::social.fields.seo_social_links.add_new'),
                                'fields' => [
                                    [
                                        'handle' => 'social_icon',
                                        'field' => [
                                            'type' => 'select',
                                            'display' => __('statamic-site-kit::social.fields.seo_social_links.icon'),
                                            'options' => self::getSocialOptions(),
                                        ],
                                    ],
                                    [
                                        'handle' => 'url',
                                        'field' => [
                                            'type' => 'text',
                                            'display' => __('statamic-site-kit::social.fields.seo_social_links.url'),
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
                'opengraph' => [
                    'display' => __('statamic-site-kit::social.fields.opengraph.display'),
                    'fields' => [
                        [
                            'handle' => 'og_image_site',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::social.fields.og_image_site.display'),
                                'instructions' => __('statamic-site-kit::social.fields.og_image_site.instruct'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                            ],
                        ],
                    ],
                ],
                'twitter' => [
                    'display' => __('statamic-site-kit::social.fields.twitter.display'),
                    'fields' => [
                        [
                            'handle' => 'twitter_username',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::social.fields.twitter_username.display'),
                                'instructions' => __('statamic-site-kit::social.fields.twitter_username.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'twitter_meta_section_site',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::social.fields.twitter_meta_section_site.display'),
                                'instructions' => __('statamic-site-kit::social.fields.twitter_meta_section_site.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'twitter_card_type_site',
                            'field' => [
                                'type' => 'select',
                                'display' => __('statamic-site-kit::social.fields.twitter_card_type_site.display'),
                                'instructions' => __('statamic-site-kit::social.fields.twitter_card_type_site.instruct'),
                                'width' => 50,
                                'default' => 'summary',
                                'options' => [
                                    'summary' => 'Summary Card',
                                    'summary_large_image' => 'Summary card with Large Image',
                                ],
                            ],
                        ],
                        [
                            'handle' => 'twitter_default_image_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::social.fields.twitter_default_image_section.display'),
                                'instructions' => __('statamic-site-kit::social.fields.twitter_default_image_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'twitter_summary_image_site',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::social.fields.twitter_summary_image_site.display'),
                                'instructions' => __('statamic-site-kit::social.fields.twitter_summary_image_site.instruct'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'twitter_summary_large_image_site',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::social.fields.twitter_summary_large_image_site.display'),
                                'instructions' => __('statamic-site-kit::social.fields.twitter_summary_large_image_site.instruct'),
                                'max_files' => 1,
                                'restrict' => false,
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                                'width' => 50,
                            ],
                        ],
                    ],
                ],
            ],
        ]);
    }

    private static function getSocialOptions()
    {
        $defaults = collect([
            'amazon' => 'Amazon',
            'android' => 'Android',
            'apple' => 'Apple',
            'behance' => 'Behance',
            'bitbucket' => 'Bitbucket',
            'codepen' => 'Codepen',
            'dribbble' => 'Dribbble',
            'facebook' => 'Facebook',
            'flickr' => 'Flickr',
            'foursquare' => 'Foursquare',
            'github' => 'Github',
            'google-plus' => 'Google Plus',
            'instagram' => 'Instagram',
            'linkedin' => 'LinkedIn',
            'medium' => 'Medium',
            'meetup' => 'Meetup',
            'orcid' => 'ORCID',
            'pinterest' => 'Pinterest',
            'reddit' => 'Reddit',
            'researchgate' => 'ResearchGate',
            'skype' => 'Skype',
            'slack' => 'Slack',
            'soundcloud' => 'Soundcloud',
            'spotify' => 'Spotify',
            'twitch' => 'Twitch',
            'twitter' => 'Twitter',
            'tumblr' => 'Tumblr',
            'whatsapp' => 'WhatsApp',
            'yelp' => 'Yelp',
            'youtube' => 'YouTube',
        ]);

        $config_options = collect(config('statamic-site-kit.custom_socials'));

        return $config_options->merge($defaults)->sort()->toArray();
    }
}
