<?php

namespace Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings;

use Michaelravedoni\StatamicSiteKit\Blueprints\Blueprint as StatamicSiteKitBlueprint;
use Statamic\Facades\Blueprint as StatamicBlueprint;

class InformationsBlueprint implements StatamicSiteKitBlueprint
{
    /**
     * @inheritDoc
     */
    public static function requestBlueprint()
    {
        return StatamicBlueprint::make()->setContents([
            'sections' => [
                __('statamic-site-kit::informations.tabs.main') => [
                    'fields' => [
                        [
                            'handle' => 'details_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.details_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.details_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'name',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.name.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.name.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'description',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::informations.fields.description.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.description.instruct'),
                            ],
                        ],
                        [
                            'handle' => 'contact_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.contact_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.contact_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'email',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.email.display'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'phone',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.phone.display'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'address',
                            'field' => [
                                'type' => 'textarea',
                                'display' => __('statamic-site-kit::informations.fields.address.display'),
                                'width' => 100,
                            ],
                        ],
                        [
                            'handle' => 'postal_code',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.postal_code.display'),
                                'width' => 25,
                            ],
                        ],
                        [
                            'handle' => 'locality',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.locality.display'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'country',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.country.display'),
                                'width' => 25,
                            ],
                        ],
                    ],
                ],
                __('statamic-site-kit::informations.tabs.map') => [
                    'fields' => [
                        [
                            'handle' => 'geo_coordinates_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.geo_coordinates_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.geo_coordinates_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'geo_longitude',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.geo_longitude.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.geo_longitude.instruct'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'geo_latitude',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.geo_latitude.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.geo_latitude.instruct'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'google_maps_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.google_maps_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.google_maps_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'google_place_id',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::informations.fields.google_place_id.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.google_place_id.instruct'),
                                'width' => 100,
                            ],
                        ],
                    ],
                ],
                __('statamic-site-kit::informations.tabs.logo') => [
                    'fields' => [
                        [
                            'handle' => 'logo_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.logo_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.logo_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'logo',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::informations.fields.logo.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.logo.instruct'),
                                'container' => config('statamic-site-kit.asset_container', 'assets'),
                                'folder' => 'logo',
                                'restrict' => 'true',
                                'max_files' => 1,
                            ],
                        ],
                        [
                            'handle' => 'logo_white',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::informations.fields.logo_white.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.logo_white.instruct'),
                                'container' => config('statamic-site-kit.asset_container', 'assets'),
                                'folder' => 'logo',
                                'restrict' => 'true',
                                'max_files' => 1,
                            ],
                        ],
                        [
                            'handle' => 'logo_bw',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::informations.fields.logo_bw.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.logo_bw.instruct'),
                                'container' => config('statamic-site-kit.asset_container', 'assets'),
                                'folder' => 'logo',
                                'restrict' => 'true',
                                'max_files' => 1,
                            ],
                        ],
                        [
                            'handle' => 'logo_square',
                            'field' => [
                                'type' => 'assets',
                                'display' => __('statamic-site-kit::informations.fields.logo_square.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.logo_square.instruct'),
                                'container' => config('statamic-site-kit.asset_container', 'assets'),
                                'folder' => 'logo',
                                'restrict' => 'true',
                                'max_files' => 1,
                            ],
                        ],
                    ],
                ],
                __('statamic-site-kit::informations.tabs.social') => [
                    'fields' => [
                        [
                            'handle' => 'social_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.social_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.social_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'social_links',
                            'field' => [
                                'type' => 'grid',
                                'display' => __('statamic-site-kit::informations.fields.seo_social_links.display'),
                                'add_row' => __('statamic-site-kit::informations.fields.seo_social_links.add_new'),
                                'fields' => [
                                    [
                                        'handle' => 'social_icon',
                                        'field' => [
                                            'type' => 'select',
                                            'display' => __('statamic-site-kit::informations.fields.seo_social_links.icon'),
                                            'options' => self::getSocialOptions(),
                                        ],
                                    ],
                                    [
                                        'handle' => 'url',
                                        'field' => [
                                            'type' => 'text',
                                            'display' => __('statamic-site-kit::informations.fields.seo_social_links.url'),
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
                __('statamic-site-kit::informations.tabs.openning_hours') => [
                    'fields' => [
                        [
                            'handle' => 'openning_hours_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::informations.fields.openning_hours_section.display'),
                                'instructions' => __('statamic-site-kit::informations.fields.openning_hours_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'openning_hours',
                            'field' => [
                                'type' => 'grid',
                                'mode' => 'table',
                                'display' => __('statamic-site-kit::informations.fields.openning_hours.display'),
                                'add_row' => __('statamic-site-kit::informations.fields.openning_hours.add_new'),
                                'fields' => [
                                    [
                                        'handle' => 'enabled',
                                        'field' => [
                                            'type' => 'toggle',
                                            'display' => __('statamic-site-kit::informations.fields.openning_hours.enabled'),
                                        ],
                                    ],
                                    [
                                        'handle' => 'weekday',
                                        'field' => [
                                            'type' => 'text',
                                            'display' => __('statamic-site-kit::informations.fields.openning_hours.weekday'),
                                        ],
                                    ],
                                    [
                                        'handle' => 'hour',
                                        'field' => [
                                            'type' => 'text',
                                            'display' => __('statamic-site-kit::informations.fields.openning_hours.hour'),
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ]);
    }

    private static function getSocialOptions()
    {
        $defaults = collect([
            'amazon' => 'Amazon',
            'android' => 'Android',
            'apple' => 'Apple',
            'behance' => 'Behance',
            'bitbucket' => 'Bitbucket',
            'codepen' => 'Codepen',
            'dribbble' => 'Dribbble',
            'facebook' => 'Facebook',
            'flickr' => 'Flickr',
            'foursquare' => 'Foursquare',
            'github' => 'Github',
            'google-plus' => 'Google Plus',
            'instagram' => 'Instagram',
            'linkedin' => 'LinkedIn',
            'medium' => 'Medium',
            'meetup' => 'Meetup',
            'orcid' => 'ORCID',
            'pinterest' => 'Pinterest',
            'reddit' => 'Reddit',
            'researchgate' => 'ResearchGate',
            'skype' => 'Skype',
            'slack' => 'Slack',
            'soundcloud' => 'Soundcloud',
            'spotify' => 'Spotify',
            'twitch' => 'Twitch',
            'twitter' => 'Twitter',
            'tumblr' => 'Tumblr',
            'whatsapp' => 'WhatsApp',
            'yelp' => 'Yelp',
            'youtube' => 'YouTube',
        ]);

        $config_options = collect(config('statamic-site-kit.custom_socials'));

        return $config_options->merge($defaults)->sort()->toArray();
    }
}
