<?php

namespace Michaelravedoni\StatamicSiteKit\Blueprints\CP\Settings;

use Michaelravedoni\StatamicSiteKit\Blueprints\Blueprint as StatamicSiteKitBlueprint;
use Statamic\Facades\Blueprint as StatamicBlueprint;

class ManifestsBlueprint implements StatamicSiteKitBlueprint
{
    /**
     * @inheritDoc
     */
    public static function requestBlueprint()
    {
        return StatamicBlueprint::make()->setContents([
            'sections' => [
                'web' => [
                    'fields' => [
                        [
                            'handle' => 'web_manifest_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_section.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_name',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_name.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_name.instruct'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_short_name',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_short_name.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_short_name.instruct'),
                                'width' => 50,
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_description',
                            'field' => [
                                'type' => 'text',
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_description.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_description.instruct'),
                                'width' => 100,
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_display',
                            'field' => [
                                'type' => 'select',
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_display.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_display.instruct'),
                                'options' => [
                                    'fullscreen' => 'Fullscreen',
                                    'standalone' => 'Standalone',
                                    'minimal-ui' => 'Minimal UI',
                                    'browser' => 'Browser',
                                ],
                                'default' => 'minimal-ui',
                                'width' => 100,
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_icon',
                            'field' => [
                                'type' => 'assets',
                                'max_files' => 1,
                                'restrict' => false,
                                'width' => 100,
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_icon.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_icon.instruct'),
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_icon_svg',
                            'field' => [
                                'type' => 'assets',
                                'max_files' => 1,
                                'restrict' => false,
                                'width' => 100,
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_icon_svg.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_icon_svg.instruct'),
                                'container' => config('statamic-site-kit.asset_container'),
                                'folder' => config('statamic-site-kit.asset_folder'),
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_theme_color',
                            'field' => [
                                'type' => 'color',
                                'width' => 50,
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_theme_color.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_theme_color.instruct'),
                                'default' => '#ffffff',
                            ],
                        ],
                        [
                            'handle' => 'web_manifest_background_color',
                            'field' => [
                                'type' => 'color',
                                'width' => 50,
                                'display' => __('statamic-site-kit::manifests.fields.web_manifest_background_color.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.web_manifest_background_color.instruct'),
                                'default' => '#2b5797',
                            ],
                        ],
                    ],
                ],
                'humans' => [
                    'fields' => [
                        [
                            'handle' => 'humans_manifest_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::manifests.fields.humans_manifest_section.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.humans_manifest_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'humans_manifest',
                            'field' => [
                                'type' => 'code',
                                'mode' => 'txt',
                                'display' => __('statamic-site-kit::manifests.fields.humans_manifest.display'),
                                'width' => 100,
                            ],
                        ],
                    ],
                ],
                'analytics' => [
                    'fields' => [
                        [
                            'handle' => 'analytics_manifest_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::manifests.fields.analytics_manifest_section.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.analytics_manifest_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'analytics_manifest',
                            'field' => [
                                'type' => 'code',
                                'mode' => 'txt',
                                'display' => __('statamic-site-kit::manifests.fields.analytics_manifest.display'),
                                'width' => 100,
                            ],
                        ],
                    ],
                ],
                'security' => [
                    'fields' => [
                        [
                            'handle' => 'security_manifest_section',
                            'field' => [
                                'type' => 'section',
                                'display' => __('statamic-site-kit::manifests.fields.security_manifest_section.display'),
                                'instructions' => __('statamic-site-kit::manifests.fields.security_manifest_section.instruct'),
                                'listable' => 'hidden',
                            ],
                        ],
                        [
                            'handle' => 'security_manifest',
                            'field' => [
                                'type' => 'code',
                                'mode' => 'txt',
                                'display' => __('statamic-site-kit::manifests.fields.security_manifest.display'),
                                'width' => 100,
                            ],
                        ],
                    ],
                ],
            ],
        ]);
    }
}
