<?php

namespace Michaelravedoni\StatamicSiteKit\Schema\Parts;

use Carbon\Carbon;
use Michaelravedoni\StatamicSiteKit\Modifiers\ParseLocaleModifier;
use Michaelravedoni\StatamicSiteKit\Schema\Parts\Contracts\SchemaPart;
use Michaelravedoni\StatamicSiteKit\Schema\SchemaIds;
use Spatie\SchemaOrg\Schema;
use Statamic\Facades\Config;
use Statamic\Facades\URL;

class WebPage implements SchemaPart
{
    public function __construct($context = [])
    {
        $this->context = $context;
    }

    public function data()
    {
        $page = Schema::webPage();
        $page->setProperty('@id', self::id());
        $page->url(URL::makeAbsolute(URL::getCurrent()));
        $title = $this->context->get('og_title') ?: $this->context->get('title', '');
        $page->name($title);
        $page->isPartOf(['@id' => WebSite::id()]);
        $page->inLanguage(ParseLocaleModifier::index(Config::getFullLocale()));
        if ($this->context->get('last_modified')) {
            $lastModifiedTimestamp = Carbon::parse($this->context->get('last_modified'))->format('c');
            $page->datePublished($lastModifiedTimestamp);
            $page->dateModified($lastModifiedTimestamp);
        }

        return $page;
    }

    public static function id()
    {
        return URL::makeAbsolute(Config::getSiteUrl()).SchemaIds::WEB_PAGE;
    }
}
