<?php

namespace Michaelravedoni\StatamicSiteKit;

use Michaelravedoni\StatamicSiteKit\Commands\UpdateGit as CommandsUpdateGit;
use Michaelravedoni\StatamicSiteKit\Commands\UpdateGitDry as CommandsUpdateGitDry;
use Michaelravedoni\StatamicSiteKit\Events\Redirects\ManualRedirectCreated;
use Michaelravedoni\StatamicSiteKit\Events\Redirects\ManualRedirectDeleted;
use Michaelravedoni\StatamicSiteKit\Events\Redirects\ManualRedirectSaved;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitContentDefaultsSaved;
use Michaelravedoni\StatamicSiteKit\Events\StatamicSiteKitGlobalsUpdated;
use Michaelravedoni\StatamicSiteKit\Middleware\CheckIfSuperToken;
use Michaelravedoni\StatamicSiteKit\Modifiers\ParseLocaleModifier;
use Michaelravedoni\StatamicSiteKit\Tags\StatamicSiteKitTags;
use Statamic\Facades\CP\Nav;
use Statamic\Facades\Git;
use Statamic\Facades\Permission;
use Statamic\Providers\AddonServiceProvider;
use Statamic\Statamic;

class ServiceProvider extends AddonServiceProvider
{
    public function bootAddon()
    {
        //
    }

    protected $commands = [
        CommandsUpdateGit::class,
        CommandsUpdateGitDry::class,
    ];

    protected $fieldtypes = [
        //
    ];

    protected $listen = [
        //
    ];

    protected $middlewareGroups = [
        'statamic.web' => [
            //
        ],
    ];

    protected $modifiers = [
        ParseLocaleModifier::class,
    ];

    protected $routes = [
        'web' => __DIR__.'/../routes/web.php',
    ];

    protected $scripts = [
        __DIR__.'/../public/js/statamic-site-kit.js',
    ];

    protected $stylesheets = [
        __DIR__.'/../public/css/statamic-site-kit.css',
        __DIR__.'/../resources/css/cp.css',
    ];

    protected $subscribe = [
        //
    ];

    protected $tags = [
        StatamicSiteKitTags::class,
    ];

    public function boot()
    {
        parent::boot();

        // Set up views path
        $this->loadViewsFrom(__DIR__.'/../resources/views', 'statamic-site-kit');

        // Set up translations
        $this->loadTranslationsFrom(__DIR__.'/../resources/lang', 'statamic-site-kit');

        // Load config
        $this->mergeConfigFrom(__DIR__.'/../config/statamic-site-kit.php', 'statamic-site-kit');

        $this->publishes([
            __DIR__.'/../config/statamic-site-kit.php' => config_path('statamic-site-kit.php'),
        ], 'config');

        // Load globals blueprint and content
        $this->publishes([
            __DIR__.'/../resources/blueprints/globals' => resource_path('blueprints/globals'),
            __DIR__.'/../content/globals' => base_path('content/globals'),
        ], 'globals');

        // Set up middlewares
        app('router')->aliasMiddleware('super_token', CheckIfSuperToken::class);

        // Set up permissions
        $this->bootPermissions();

        // Set up navigation
        $this->bootNav();

        // Set up git integration
        $this->bootGitListener();
    }

    /**
     * Add our custom navigation items to the CP nav
     *
     * @return void
     */
    public function bootNav()
    {
        Nav::extend(function ($nav) {
            $nav->remove('Content', 'Globals', 'Info');
            $nav->tools(__('statamic-site-kit::informations.plural'))
                ->url('globals/info')
                ->icon('<svg xmlns="http://www.w3.org/2000/svg" viewBox="-18.75 -18.75 600 600" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" id="Tags--Streamline-Lucide" height="600" width="600"><desc>Tags Streamline Icon: https://streamlinehq.com</desc><path d="m351.5625 117.1875 147.65625 147.65625a56.25 56.25 0 0 1 0 79.6875L398.4375 445.3125" stroke-width="37.5"></path><path d="M224.671875 130.921875A46.875 46.875 0 0 0 191.53125 117.1875H70.3125a23.4375 23.4375 0 0 0 -23.4375 23.4375v121.21875a46.875 46.875 0 0 0 13.734375 33.140625L194.29687499999997 428.671875a56.85937500000001 56.85937500000001 0 0 0 80.15625 0l83.90625 -83.90625a56.85937500000001 56.85937500000001 0 0 0 0 -80.15625z" stroke-width="37.5"></path><path fill="#000000" d="M140.625 222.65625a11.71875 11.71875 0 1 0 23.4375 0 11.71875 11.71875 0 1 0 -23.4375 0" stroke-width="37.5"></path></svg>');
        });
    }

    /**
     * Add permissions for Statamic Site Kit
     *
     * @return void
     */
    public function bootPermissions()
    {
        $seo_groups = [
            [
                'value' => 'informations',
                'label' => 'Informations',
            ],
        ];

        Permission::group('statamic-site-kit', 'Statamic Site Kit', function () {
            Permission::register('configure ssk informations', function ($permission) {
                $permission->children([
                    Permission::make('view ssk informations')
                        ->label(__('statamic-site-kit::main.permissions.informations.view'))
                        ->children([
                            Permission::make('view ssk informations informations')
                                ->label(__('statamic-site-kit::informations.permissions.view')),
                            Permission::make('update ssk informations informations')
                                ->label(__('statamic-site-kit::informations.permissions.update')),
                        ]),
                ]);
            })->label(__('statamic-site-kit::main.permissions.informations.configure'));
        });
    }

    /**
     * Register our custom events with the Statamic git integration
     */
    protected function bootGitListener(): void
    {
        if (config('statamic.git.enabled')) {
            $events = [
                StatamicSiteKitContentDefaultsSaved::class,
                StatamicSiteKitGlobalsUpdated::class,
                ManualRedirectCreated::class,
                ManualRedirectDeleted::class,
                ManualRedirectSaved::class,
            ];

            foreach ($events as $event) {
                Git::listen($event);
            }
        }
    }

    /**
     * Register our custom Schedule
     *
     * @return void
     */
    protected function schedule($schedule)
    {
        $schedule->command(CommandsUpdateGit::class)->hourly();
    }
}
